function [mu,cor,index_A,h_o] = GPR_MC(f_c, x,h,Kernal,sigma2,P,N_ports)

N = length(x);

lambda = 3e8/f_c;

index_A = [];                % Index of observed points
A_t = [];                    % Observed points
h_o = [];                    % Value of observed points

mu = zeros(N,1);
cor = ones(N,1);

d = x(2)-x(1);               % Antenna spacing
delta = ceil(lambda/2/d);

for p = 1:P

    Candidate_index = [1:1:N]';
    for n = 1:N_ports

        if p == 1 && n == 1
            kmax = randperm(N,1);
        else
            Candidate_num = length(Candidate_index);
            Candidate_value = zeros(Candidate_num,1);

            for bb =1:Candidate_num
                Candidate_value(bb) = Sigma_k(Candidate_index(bb),Candidate_index(bb));
            end

            [~,kmax_index] = max(Candidate_value);
            kmax = Candidate_index(kmax_index);
        end

        [Remove_index_1,~] = find(Candidate_index<kmax+delta);
        [Remove_index_2,~] = find(Candidate_index>kmax-delta);
        Remove_index = intersect(Remove_index_1, Remove_index_2);

        Candidate_index(Remove_index) = [];

        A_t = [A_t x(kmax)];
        h_o = [h_o; h(kmax) + sqrt(sigma2/2)*(randn()+1j*randn())];

        index_A = [index_A kmax];

        Observed_length = length(h_o);
        k_t = zeros(Observed_length,1);
        K_t = Kernal(index_A,index_A);

        k_t = Kernal(index_A,:);
        mu = k_t'*(K_t+sigma2*eye(Observed_length))^(-1)*h_o;
        Sigma_k = Kernal - k_t'*(K_t+sigma2*eye(Observed_length))^(-1)*k_t;
        cor = abs(sqrt(diag(Sigma_k)));
    end
end

